% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_tree_curve.R
\name{average_tree_curve}
\alias{average_tree_curve}
\title{Generate the curve of a forest's average tree using the Kozak taper model}
\usage{
average_tree_curve(df, d, dbh, h, th, facet = NA)
}
\arguments{
\item{df}{A data frame.}

\item{d}{Quoted name of the section diameter variable, in cm.}

\item{dbh}{Quoted name of the diameter at breast height variable, in cm.}

\item{h}{Quoted name of the section height variable, in meters.}

\item{th}{Quoted name of the total height variable, in meters.}

\item{facet}{Optional argument. If supplied with the Quoted name of a factor variable(s), this variable is used to divide the plot into facets. Default: NA.}
}
\value{
A ggplot object.
}
\description{
Generate a ggplot curve of a forest's average tree using the Kozak taper model (Kozak, Munro and Smith, 1969).
}
\examples{
library(forestmangr)
data("exfm7")
head(exfm7)
   
average_tree_curve(df = exfm7, d = "di_wb", dbh = "DBH", h = "hi", th = "TH")
average_tree_curve(df = exfm7, d = "di_wb", dbh = "DBH", h = "hi", th = "TH", facet = "STRATA")

}
\references{
Kozak, A., Munro, D. D. and Smith, J. H. G. (1969) Taper Functions and their Application in Forest Inventory, The Forestry Chronicle, 45, pp. 278–283.
}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
