% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reality_productivity.R
\name{reality.productivity}
\alias{reality.productivity}
\title{Calculate the reality productivity.}
\usage{
reality.productivity(forestData, left = 0.05, right = 100)
}
\arguments{
\item{forestData}{A forestData class data}

\item{left}{Solving for the left boundary of the reality productivity.}

\item{right}{Solving for the right boundary of the reality productivity.}
}
\value{
A forestData class in which a data.frame with reality productivity parameters is added.
}
\description{
reality.productivity calculate the reality productivity of each tree based on model parameters(obtained from the parameterOutput function).
}
\details{
reality.productivity takes data,data_BA,data_V parameters as required inputs.
}
\examples{
\donttest{
# Load sample data
data("forestData")

# Build a model based on the forestData and return a forestData class object
forestData <- class.plot(forestData,model="Richards",
                         interval=5,number=5,
                         a=19,b=0.1,c=0.8)

# Calculate the reality productivity of the forestData object
forestData <- reality.productivity(forestData,left=0.05,right=100)
}
}
