% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta.R
\name{forecast.thetam}
\alias{forecast.thetam}
\title{Forecast using a Theta model}
\usage{
\method{forecast}{thetam}(
  object,
  h = ifelse(object$m > 1, 2 * object$m, 10),
  level = c(80, 95),
  fan = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class "\code{thetam}.  Usually the result of a call
to \code{link{thetam}}.}

\item{h}{Number of periods for forecasting}

\item{level}{Confidence level for prediction intervals}

\item{fan}{If TRUE, level is set to \code{seq(51, 99, by = 3)}. This is suitable for fan plots.}

\item{...}{Ignored}
}
\value{
An object of class \code{forecast}
}
\description{
Returns forecasts and other information for univariate Theta "models"
}
\examples{
mod1 <- thetam(Nile)
fc1 <- forecast(mod1)
plot(fc1)
}
\seealso{
\code{\link{thetam}}
}
\author{
Peter Ellis
}
