% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuv_batch.R
\name{tuv_batch}
\alias{tuv_batch}
\title{Calculate TUV in Batch Online}
\usage{
tuv_batch(df, inputMode = 0, outputMode = 2, nStreams = -2)
}
\arguments{
\item{df}{Dataframe of time series of parameters. The first column of df should be datetime. The other columns (names) could be set as following: \cr
wStart -> Shortest wavelength. The default value is 280. \cr  
wStop -> Longest wavelength.  The default value is 420. \cr
wIntervals -> Number of equal-sized subdivisions of the range End-Start. The default value is 140. \cr 
latitude -> Latitudes: positive North of equator, negative South of equator. The default value is 0. \cr
longitude -> Longitudes: positive East of the Greenwich meridian, negative West of the Greenwich meridian. The default value is 0. \cr  
zenith -> Solar zenith angle (deg). The default value is 0. \cr
ozone -> Ozone column, in Dobson Units (du), vertical, from ground (even if above sea level) to space. The US Standard Atmosphere O3 is used to specify the shape of the vertical profile but the total column is re-scaled to the value selected here by the user. The default value is 300. \cr
albedo -> Surface albedo: Assumes a Lambertian reflection (isotropic radiance) Values for snow can reach 0.90-0.99, but otherwise values at UV wavelengths are in the range 0.02-0.20 depending on the precise surface.  The default value is 0.1.
gAltitude -> Ground elevation: The elevation of the ground, in km above mean sea level.  The default value is 0. \cr
mAltitude -> Measurement altitude: The altitude in the atmosphere for which results are requested. This should not be confused with the ground elevation. For example, if you have measurements made from an airplane, flying at 6 km above the ground, and the surface is at 1.5 km, then you will want to request results for a measurement altitude of 7.5 km asl.   The default value is 0. \cr
taucld -> Cloud Optical Depth: vertical optical depth of the cloud. The default value is 0.00.  \cr
zbase -> Cloud base: base of cloud, in km (asl). The default value is 4.00. \cr  
ztop -> Cloud top:  top of cloud, in km (asl). The default value is 5.00. \cr  
tauaer -> Optical Depth: total extinction (absorption + scattering) at 550 nm, vertical, from ground to space. The default value is 0.235. \cr
ssaaer -> Single Scattering Albedo (S-S alb), assumed independent of wavelength. The default value is 0.990. \cr
alpha -> Alpha (Angstrom exponent), gives wavelength dependence of optical depth, by multiplying the 550 nm value by (550 nm/wavelength, nm)**alpha. The default value is 1.000. \cr
dirsun -> Direct beam, direct solar beam. The default value is 1.0. \cr 
difdn -> Diffuse down, down-ward propagating scattered radiation (diffuse sky light). The default value is 1.0. \cr  
difup -> Diffuse up, up-ward propagating scattered radiation (diffuse light from below). The default value is NA. \cr}

\item{inputMode}{The default value is 0. InputMode 0: User-specified geographic location and time/date. The code computes the appropriate solar zenith angle and Earth-Sun distance.  InputMode 1: User specifies the solar zenith angle, and the annual average Earth-Sun distance is used. To avoid inconsistencies (e.g. overhead sun at the poles), options 1 and 2 cannot be invoked at the same time.}

\item{outputMode}{The default value is 2.  OutputMode 2: Molecular photolysis frequencies (109 photoreactions). OutputMode 3: Weighted irradiance (27 weighting functions). OutputMode 4: Spectral actinic flux. OutputMode 5: Spectral irradiance.}

\item{nStreams}{The default value is -2.   NStreams -2: Pseudo-spherical 2 streams (faster, less accurate). NStreams 4: Pseudo-spherical discrete ordinate 4 streams (slower, more accurate).}
}
\value{
a dataframe. The contents of dataframe are diterminated by OutputMode. \cr 
OutputMode 2: Molecular photolysis frequencies (109 photoreactions). \cr
OutputMode 3: Weighted irradiance (27 weighting functions). \cr
OutputMode 4: Spectral actinic flux. \cr
OutputMode 5: Spectral irradiance. \cr
}
\description{
This function runs TUV in batch online by reading the time series for the \cr
parameters to be entered, and summarizes the results to the new dataframe. \cr
}
