% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foodweb.R
\name{colorTag}
\alias{colorTag}
\title{colorTag}
\usage{
colorTag(v1, v2, nc, x, colorMap, pawn)
}
\arguments{
\item{v1}{character vector first column of m (excluding first 2 entries of m)}

\item{v2}{character vector second column of m (excluding first 2 entries of m)}

\item{nc}{integer number of columns of m}

\item{x}{return value of replaceRotTag()}

\item{colorMap}{character array of colors}

\item{pawn}{Boolean if TRUE use chess symbols rather than rectangles in html table}
}
\value{
returns
}
\description{
add tag to color function name in column 2, based on package in column 1
}
\details{
v1 is first column of m (excluding first 2 entries of m)
v2 is second column of m (excluding first 2 entries of m)
}
\examples{
if(interactive()){
v<-vector("character")
for(fun in funs_examples)
  v[fun]<-find_funs(fun)$package_name[1]

m<-concatPackFunc2(x_examples$funmat,v)
v2<-consolidate(v)
m2<-rearrangeM(m,v2)

m3<-removeZeroRowsCols(m2)
f<-sprintf("\%s/r2html",tempdir())
R2HTML::HTML(m3,file=f,append=FALSE)
x<-readLines(f)

colors<-c("darkmagenta","darkolivegreen","darkorange3","brown4","red","blue")
colorMap<-mapFunctionsColors(m3[1,c(-1,-2)],m3[c(-1,-2),1],colors)

l<-spanTag(m[1,c(-1,-2)],"COLSPAN",colorMap)

v<-vector("character")
for(fun in funs_examples)
  v[fun]<-find_funs(fun)$package_name[1]

m<-concatPackFunc2(x_examples$funmat,v)
v2<-consolidate(v)
m2<-rearrangeM(m,v2)

m3<-removeZeroRowsCols(m2)

x<-replaceRotTag(x,l,dim(m3))

colors<-c("darkmagenta","darkolivegreen","darkorange3","brown4","red","blue")
colorMap<-mapFunctionsColors(m3[1,c(-1,-2)],m3[c(-1,-2),1],colors)

x<-colorTag(m3[c(-1,-2),1],m3[c(-1,-2),2],ncol(m3),x,colorMap,pawn=TRUE)
}

}
