% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnets.R
\name{predict.fnets}
\alias{predict.fnets}
\title{Forecasting by fnets}
\usage{
\method{predict}{fnets}(object, x, h = 1, fc.restricted = TRUE, r = c("ic", "er"), ...)
}
\arguments{
\item{object}{\code{fnets} object}

\item{x}{input time series matrix, with each row representing a variable}

\item{h}{forecasting horizon}

\item{fc.restricted}{whether to forecast using a restricted or unrestricted, blockwise VAR representation of the common component}

\item{r}{number of restricted factors, or a string specifying the factor number selection method when \code{fc.restricted = TRUE};
 possible values are:
\itemize{
   \item{\code{"ic"}}{ information criteria of Bai and Ng (2002)}
   \item{\code{"er"}}{ eigenvalue ratio}
}}

\item{...}{not used}
}
\value{
a list containing
\item{forecast}{ forecasts for the given forecasting horizon}
\item{common.pred}{ a list containing forecasting results for the common component}
\item{idio.pred}{ a list containing forecasting results for the idiosyncratic component}
\item{mean.x}{ \code{mean.x} argument from \code{object}}
}
\description{
Produces forecasts of the data for a given forecasting horizon by
separately estimating the best linear predictors of common and idiosyncratic components
}
\examples{
set.seed(123)
n <- 500
p <- 50
common <- sim.restricted(n, p)
idio <- sim.var(n, p)
x <- common$data + idio$data
out <- fnets(x, q = 2, var.order = 1, var.method = "lasso",
do.lrpc = FALSE, var.args = list(n.cores = 2))
cpre.unr <- common.predict(out, x, h = 1, fc.restricted = FALSE, r = NULL)
cpre.res <- common.predict(out, x, h = 1, fc.restricted = TRUE, r = NULL)
ipre <- idio.predict(out, x, cpre.res, h = 1)
}
\references{
Ahn, S. C. & Horenstein, A. R. (2013) Eigenvalue ratio test for the number of factors. Econometrica, 81(3), 1203--1227.

Barigozzi, M., Cho, H. & Owens, D. (2022) FNETS: Factor-adjusted network estimation and forecasting for high-dimensional time series. arXiv preprint arXiv:2201.06110.

Owens, D., Cho, H. & Barigozzi, M. (2022) fnets: An R Package for Network Estimation and Forecasting via Factor-Adjusted VAR Modelling
}
\seealso{
\link[fnets]{fnets}, \link[fnets]{common.predict}, \link[fnets]{idio.predict}
}
