% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt.R
\name{value}
\alias{value}
\title{Create a user-defined format}
\usage{
value(..., log = TRUE, as.factor = FALSE)
}
\arguments{
\item{...}{One or more \code{\link{condition}} functions.}

\item{log}{Whether to log the creation of the format.  Default is
TRUE. This parameter is used internally.}

\item{as.factor}{If TRUE, the \code{\link{fapply}} function will return
the result as an ordered factor.  Otherwise, the result will be returned
as a vector.  Default is FALSE.}
}
\value{
The new format object.
}
\description{
The \code{value} function creates a user-defined format.
}
\details{
The \code{value} function creates a user defined format object, in a manner
similar to a SAS® format.  The \code{value} function accepts 
one or more \code{condition} arguments that define the format.  The 
conditions map an R expression to a label.  When applied, the format 
will return the label corresponding to the first true expression.

The format object is an S3 class of type "fmt". When the object is created,
the \strong{levels} attribute of the object will be set with a vector 
of values
assigned to the \strong{labels} property of the \code{condition} arguments.  
These labels may be accessed either from the \code{levels} function or the 
\code{labels} function.  If no order has been assigned to the conditions,
the labels will be returned in the order the conditions were passed to the
\code{value} function.  If an order has been assigned to the conditions,
the labels will be returned in the order specified.

The format object may be applied to a vector using the \code{fapply}
function.  See \code{\link{fapply}} for further details.

Note that the label may also be a string format.  That means a 
user-defined format can be used to apply string formats conditionally.
This capability is useful when you want to conditionally format 
data values.
}
\examples{
## Example 1: Character to Character Mapping ##
# Set up vector
v1 <- c("A", "B", "C", "B")

# Define format
fmt1 <- value(condition(x == "A", "Label A"),
              condition(x == "B", "Label B"), 
              condition(TRUE, "Other"))
              
# Apply format to vector
fapply(v1, fmt1)
# [1] "Label A" "Label B" "Other"   "Label B"

## Example 2: Character to Integer Mapping ##
fmt2 <- value(condition(x == "A", 1),
              condition(x == "B", 2),
              condition(TRUE, 3))

# Apply format to vector
fapply(v1, fmt2)
# [1] 1 2 3 2

## Example 3: Categorization of Continuous Variable ##
# Set up vector
v2 <- c(1, 6, 11, 7)

# Define format
fmt3 <- value(condition(x < 5, "Low"),
              condition(x >= 5 & x < 10, "High"), 
              condition(TRUE, "Out of range"))
              
# Apply format to vector
fapply(v2, fmt3)
# [1] "Low"          "High"         "Out of range" "High" 

### Example 4: Conditional formatting
v3 <- c(10.398873, 12.98762, 0.5654, 11.588372)

fmt4 <- value(condition(x < 1, "< 1.0"),
              condition(TRUE, "\%.2f"))
              
fapply(v3, fmt4)
# [1] "10.40" "12.99" "< 1.0" "11.59"

}
\seealso{
\code{\link{condition}} to define a condition,
\code{\link{levels}} or \code{\link{labels.fmt}} to access the labels, and 
\code{\link{fapply}} to apply the format to a vector.

Other fmt: 
\code{\link{as.data.frame.fmt}()},
\code{\link{as.fmt.data.frame}()},
\code{\link{as.fmt}()},
\code{\link{condition}()},
\code{\link{is.format}()},
\code{\link{labels.fmt}()},
\code{\link{print.fmt}()}
}
\concept{fmt}
