% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping.R
\name{fm_crs_plot}
\alias{fm_crs_plot}
\alias{fm_crs_graticule}
\alias{fm_crs_tissot}
\title{Plot CRS and fm_crs objects}
\usage{
fm_crs_plot(
  x,
  xlim = NULL,
  ylim = NULL,
  outline = TRUE,
  graticule = c(15, 15, 45),
  tissot = c(30, 30, 30),
  asp = 1,
  add = FALSE,
  eps = 0.05,
  ...
)

fm_crs_graticule(
  x,
  by = c(15, 15, 45),
  add = FALSE,
  do.plot = TRUE,
  eps = 0.05,
  ...
)

fm_crs_tissot(
  x,
  by = c(30, 30, 30),
  add = FALSE,
  do.plot = TRUE,
  eps = 0.05,
  diff.eps = 0.01,
  ...
)
}
\arguments{
\item{x}{A \code{crs} or \code{\link[=fm_crs]{fm_crs()}} object.}

\item{xlim}{Optional x-axis limits.}

\item{ylim}{Optional y-axis limits.}

\item{outline}{Logical, if \code{TRUE}, draw the outline of the projection.}

\item{graticule}{Vector of length at most 3, to plot meridians with spacing
\code{graticule[1]} degrees and parallels with spacing \code{graticule[2]}
degrees. \code{graticule[3]} optionally specifies the spacing above and
below the first and last parallel.  When \code{graticule[1]==0} no meridians
are drawn, and when \code{graticule[2]==0} no parallels are drawn. Use
\code{graticule=NULL} to skip drawing a graticule.}

\item{tissot}{Vector of length at most 3, to plot Tissot's indicatrices with
spacing \code{tissot[1]} degrees and parallels with spacing \code{tissot[2]}
degrees. \code{tissot[3]} specifices a scaling factor.  Use
\code{tissot=NULL} to skip drawing a Tissot's indicatrices.}

\item{asp}{The aspect ratio for the plot, default 1.}

\item{add}{If \code{TRUE}, add the projecton plot to an existing plot.}

\item{eps}{Clipping tolerance for rudimentary boundary clipping}

\item{\dots}{Additional arguments passed on to the internal calls to
\code{plot} and \code{lines}.}

\item{by}{The spacing between \verb{(long, lat, long_at_poles)}
graticules/indicatrices, see the \code{graticule} and \code{tissot} arguments.}

\item{do.plot}{logical; If TRUE, do plotting}

\item{diff.eps}{Pre-scaling}
}
\value{
\code{NULL}, invisibly
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Plot the outline of a \code{crs}
or \code{\link[=fm_crs]{fm_crs()}} projection, with optional graticules (transformed parallels
and meridians) and Tissot indicatrices.
}
\section{Functions}{
\itemize{
\item \code{fm_crs_graticule()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Constructs graticule
information for a given \code{CRS} or \code{\link[=fm_crs]{fm_crs()}} and optionally plots the
graticules.
Returns a list with two elements, \code{meridians} and \code{parallels}, which are
\code{SpatialLines} objects.

\item \code{fm_crs_tissot()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Constructs Tissot indicatrix information
for a given \code{CRS} or \code{\link[=fm_crs]{fm_crs()}} and optionally plots the indicatrices.
Returns a list with one element, \code{tissot}, which is a \code{SpatialLines} object.

}}
\examples{
\donttest{
if (require("sf") && require("sp")) {
  for (projtype in c(
    "longlat_norm",
    "lambert_norm",
    "mollweide_norm",
    "hammer_norm"
  )) {
    fm_crs_plot(fm_crs(projtype), main = projtype)
  }
}

if (require("sf") && require("sp")) {
  oblique <- c(0, 45, 45, 0)
  for (projtype in c(
    "longlat_norm",
    "lambert_norm",
    "mollweide_norm",
    "hammer_norm"
  )) {
    fm_crs_plot(
      fm_crs(projtype, oblique = oblique),
      main = paste("oblique", projtype)
    )
  }
}
}
}
\seealso{
\code{\link[=fm_crs]{fm_crs()}}
}
\author{
Finn Lindgren \href{mailto:finn.lindgren@gmail.com}{finn.lindgren@gmail.com}
}
