% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluator.R
\name{fm_basis_helpers}
\alias{fm_basis_helpers}
\alias{fm_basis_mesh_2d}
\alias{fm_basis_mesh_1d}
\title{Internal helper functions for mesh field evaluation}
\usage{
fm_basis_mesh_2d(
  mesh,
  loc = NULL,
  weights = NULL,
  derivatives = NULL,
  crs = NULL,
  ...
)

fm_basis_mesh_1d(
  mesh,
  loc,
  weights = NULL,
  derivatives = NULL,
  method = deprecated(),
  ...
)
}
\arguments{
\item{loc}{A location/value information object (vector, matrix, \code{sf}, etc,
depending on the class of \code{x})}

\item{weights}{Optional weight vector, one weight for each location}

\item{derivatives}{logical; If true, also return matrices \code{dA} and \code{d2A}
for \code{fm_mesh_1d} objects, and \code{dx}, \code{dy}, \code{dz} for \code{fm_mesh_2d}.}

\item{...}{Passed on to submethods}

\item{method}{character; either "default", "nearest", "linear", or
"quadratic". With \code{NULL} or "default", uses the object definition of the
function space. Otherwise overrides the object definition.}
}
\value{
A \code{fm_basis} object; a list of evaluator information objects,
at least a matrix \code{A} and logical vector \code{ok}.
}
\description{
Methods called internally by \code{\link[=fm_basis]{fm_basis()}} methods.
}
\examples{
str(fm_basis_mesh_2d(fmexample$mesh, loc = fmexample$loc))

}
\keyword{internal}
