
# fluxfinder

<!-- badges: start -->
  ![R-CMD-check](https://github.com/COMPASS-DOE/fluxfinder/workflows/R-CMD-check/badge.svg)
  [![Codecov test coverage](https://codecov.io/gh/r-lib/covr/branch/master/graph/badge.svg)](https://app.codecov.io/gh/r-lib/covr?branch=master)
<!-- badges: end -->

The goal of `fluxfinder` is to allow users to straightforwardly parse
data files generated by infrared gas analyzers used in environmental
sciences research; match data and metadata; compute greenhouse gas fluxes;
and generate QA/QC plots and diagnostics.

We emphasize clear and well-documented code, good documentation, and
focused functions that can be easily integrated into conventional 
or [tidyverse](https://www.tidyverse.org)-style analytical pipelines.

It is also straightforward to integrate this package's utilities with
the more powerful flux-computation capabilities of the
[gasfluxes](https://cran.r-project.org/package=gasfluxes) package.

## Installation

You can install `fluxfinder` from CRAN...

```r
install.packages("fluxfinder")
```

...or the development version of fluxfinder from [GitHub](https://github.com/) with:

``` r
# install.packages("remotes")
remotes::install_github("COMPASS-DOE/fluxfinder", build_vignettes = TRUE)
```

## Supported data file types

Currently `fluxfinder` provides functions to read data from:

* The [LI-COR Smart Chamber](https://www.licor.com/env/products/soil-flux/smart-chamber)
* [LI-COR 78xx Trace Gas Analyzers](https://www.licor.com/env/products/trace-gas/), including the LI-7810 and LI-7820
* Older [LGR 915](https://new.abb.com/products/measurement-products/analytical/laser-gas-analyzers/laser-analyzers/lgr-icos-portable-analyzers) analyzers
* The [Picarro G2301](https://www.picarro.com/environmental/products/g2301_gas_concentration_analyzer)
* The [EGM-4](https://ppsystems.com/download/technical_manuals/80061-1%20EGM4_Operation_V419.pdf)
* The [LI-COR LI-850](https://www.licor.com/env/support/LI-850/topics/specifications.html)

## Next steps

See the [introductory vignette](https://github.com/COMPASS-DOE/fluxfinder/blob/main/vignettes/intro-to-fluxfinder.Rmd)!
That is the best and most up-to-date resource.

## Citation

If you use `fluxfinder` in your research, please cite it! See `citation("fluxfinder")`.
