% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc_merge.R
\name{fc_merge}
\alias{fc_merge}
\title{fc_merge}
\usage{
fc_merge(fcs)
}
\arguments{
\item{fcs}{list with all the flowcharts that we want to merge}
}
\value{
List containing a list with the datasets belonging to each flowchart and another list with each of the flowcharts parameters to merge.
}
\description{
This function allows to combine horizontally two different flowcharts.
}
\examples{
# Create first flowchart for ITT
fc1 <- safo |>
  as_fc(label = "Patients assessed for eligibility") |>
  fc_filter(itt == "Yes", label = "Intention to treat (ITT)")


# Create second flowchart for PP
fc2 <- safo |>
  as_fc(label = "Patients assessed for eligibility") |>
 fc_filter(pp == "Yes", label = "Per protocol (PP)")

list(fc1, fc2) |>
  fc_merge() |>
  fc_draw()

}
