% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc_split.R
\name{fc_split}
\alias{fc_split}
\title{fc_split}
\usage{
fc_split(
  object,
  var = NULL,
  N = NULL,
  label = NULL,
  text_pattern = "{label}\\n {n} ({perc}\%)",
  perc_total = FALSE,
  sel_group = NULL,
  na.rm = FALSE,
  show_zero = FALSE,
  round_digits = 2,
  just = "center",
  text_color = "black",
  text_fs = 8,
  text_fface = 1,
  text_ffamily = NA,
  text_padding = 1,
  bg_fill = "white",
  border_color = "black",
  title = NULL,
  text_color_title = "black",
  text_fs_title = 10,
  text_fface_title = 1,
  text_ffamily_title = NA,
  text_padding_title = 0.6,
  bg_fill_title = "white",
  border_color_title = "black",
  offset = NULL
)
}
\arguments{
\item{object}{fc object that we want to split.}

\item{var}{variable column of the database from which it will be splitted.}

\item{N}{Number of rows after the split in case `var` is NULL.}

\item{label}{Vector of characters with the label of each category in order. It has to have as many elements as categories has the column. By default, it will put the labels of the categories.}

\item{text_pattern}{Structure that will have the text in each of the boxes. It recognizes label, n, N and perc within brackets. For default it is "\{label\}\\n \{n\} (\{perc\}\%)".}

\item{perc_total}{logical. Should percentages be calculated using the total number of rows at the beginning of the flowchart? Default is FALSE, meaning that they will be calculated using the number at the parent leaf.}

\item{sel_group}{Specify if the splitting has to be done only by one of the previous groups. Default is NULL.}

\item{na.rm}{logical. Should missing values of the grouping variable be removed? Default is FALSE.}

\item{show_zero}{logical. Should the levels of the grouping variable that don't have data be shown? Default is FALSE.}

\item{round_digits}{Number of digits to round percentages. It is 2 by default.}

\item{just}{Justification for the text: left, center or right. Default is center.}

\item{text_color}{Color of the text. It is black by default.}

\item{text_fs}{Font size of the text. It is 8 by default.}

\item{text_fface}{Font face of the text. It is 1 by default. See the `fontface` parameter for \code{\link{gpar}}.}

\item{text_ffamily}{Changes the font family of the text. Default is NA. See the `fontfamily` parameter for \code{\link{gpar}}.}

\item{text_padding}{Changes the text padding inside the box. Default is 1. This number has to be greater than 0.}

\item{bg_fill}{Box background color. It is white by default.}

\item{border_color}{Box border color. It is black by default.}

\item{title}{Add a title box to the split. Default is NULL. It can only be used when there are only two resulting boxes after the split.}

\item{text_color_title}{Color of the title text. It is black by default.}

\item{text_fs_title}{Font size of the title text. It is 8 by default.}

\item{text_fface_title}{Font face of the title text. It is 1 by default. See the `fontface` parameter for \code{\link{gpar}}.}

\item{text_ffamily_title}{Changes the font family of the title text. Default is NA. See the `fontfamily` parameter for \code{\link{gpar}}.}

\item{text_padding_title}{Changes the title text padding inside the box. Default is 1. This number has to be greater than 0.}

\item{bg_fill_title}{Title box background color. It is white by default.}

\item{border_color_title}{Title box border color. It is black by default.}

\item{offset}{Amount of space to add to the distance between boxes (in the x coordinate). If positive, this distance will be larger. If negative, it will be smaller. This number has to be at least between 0 and 1 (plot limits) and the resulting x coordinate cannot exceed these plot limits. The default is NULL (no offset).}
}
\value{
List with the dataset grouped by the splitting variable and the flowchart parameters with the resulting split.
}
\description{
This function allows to split the flowchart in function of the categories of a column of the database. It will generate as many boxes as categories has the column showing in each one the frequency of each category. It will additionally group the database per this column.
}
\examples{
safo |>
  dplyr::filter(!is.na(group)) |>
  as_fc(label = "Randomized patients") |>
  fc_split(group) |>
  fc_draw()

}
