% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweep.r
\docType{methods}
\name{sweep}
\alias{sweep}
\alias{sweep,float32-method}
\title{sweep}
\usage{
\S4method{sweep}{float32}(x, MARGIN, STATS, FUN = "-",
  check.margin = TRUE, ...)
}
\arguments{
\item{x}{A float vector/matrix.}

\item{MARGIN}{1 (rows) or 2 (columns)}

\item{STATS}{Vector to sweep out.}

\item{FUN}{Sweeping function; must be one of \code{"+"}, \code{"-"}, \code{"*"},  or
\code{"/"}.}

\item{check.margin}{Should x/STATS margin lengths be checked?}

\item{...}{Theoretically these are additional arguments passed to an arbitrary function.
However, we only support basic arithmetic, so they are ignored.}
}
\value{
A matrix of the same type as the highest precision input.
}
\description{
Sweep a vector through a float matrix.
}
\details{
Note that if the length of \code{STATS} does not recycle exactly across
\code{MARGIN}, the results here will differ slightly from the results of
base R.
}
\examples{
library(float)

s = flrunif(10, 3)
sweep(s, 2, fl(1))

}
