% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flipscores.R
\name{flipscores}
\alias{flipscores}
\title{Robust testing in GLMs, by sign-flipping score contributions}
\usage{
flipscores(formula, family, data, score_type, 
n_flips=5000, alternative ="two.sided", id = NULL, ...)
}
\arguments{
\item{formula}{see \code{glm} function.}

\item{family}{see \code{glm} function.}

\item{data}{see \code{glm} function.}

\item{score_type}{The type of score that is computed. It can be "orthogonalized", "effective" or "basic". 
Both "orthogonalized" and "effective" take into account the nuisance estimation and they provide the same
test statistic. In case of small samples "effective score" might have a slight anti-conservative behaviour. 
"orthogonalized effective score" gives a solution for this issue.
Note that in case of a big model matrix, the "orthogonalized" may take a long time.}

\item{n_flips}{The number of random flips of the score contributions.
When \code{n_flips} is equal or larger than the maximum number of possible flips (i.e. n^2), all possible flips are performed.}

\item{alternative}{It can be "greater", "less" or "two.sided" (default)}

\item{id}{a \code{vector} identifying the clustered observations. If \code{NULL} (default) observations are assumed to be independent.}

\item{...}{see \code{glm} function.}
}
\value{
glm class object with sign-flip score test.
See also the related functions (\code{summary.flipscores}, \code{anova.flipscores}, \code{print.flipscores}).
}
\description{
Provides robust tests for testing in GLMs, by sign-flipping score contributions. The tests are often robust against overdispersion, heteroscedasticity and, in some cases, ignored nuisance variables.
}
\details{
\code{flipscores} borrow the same parameters from function \code{glm} (and \code{glm.nb}). See these helps for more details about parameters such as \code{formula},
\code{data}, \code{family}. Note: in order to use Negative Binomial family, \code{family} reference must have quotes (i.e. \code{family="negbinom"}).
}
\examples{
set.seed(1)
dt=data.frame(X=rnorm(20),
   Z=factor(rep(LETTERS[1:3],length.out=20)))
dt$Y=rpois(n=20,lambda=exp(dt$Z=="C"))
mod=flipscores(Y~Z+X,data=dt,family="poisson",score_type = "effective")
summary(mod)
}
\references{
"Robust testing in generalized linear models by sign-flipping score contributions" by J.Hemerik, J.Goeman and L.Finos.
}
\seealso{
\code{\link{anova.flipscores}}, \code{\link{summary.flipscores}}, \code{\link[flip]{flip}}
}
\author{
Livio Finos, Vittorio Giatti, Jesse Hemerik and Jelle Goeman
}
