% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPValue.R
\name{distDataPValue}
\alias{distDataPValue}
\title{A Non-parametric Test for Exchangeability and Homogeneity (Distance List Version)}
\usage{
distDataPValue(dist_list, largeP = FALSE, nruns = 1000)
}
\arguments{
\item{dist_list}{The list of distances}

\item{largeP}{Boolean indicating whether to use large \eqn{P} asymptotics. Default is FALSE.}

\item{nruns}{Resampling number for exact test. Default is 1000.}
}
\value{
The p-value to be used to test the null hypothesis of exchangeability
}
\description{
Computes the p-value of a multivariate dataset, which
informs the user if the sample is exchangeable at a given
significance level, while simultaneously accounting for feature
dependencies. See Aw, Spence and Song (2021) for details.
}
\details{
This version takes in a list of distance matrices recording
pairwise distances between individuals across \eqn{B} independent features.

Dependencies: distDataLargeP and distDataPermute from auxiliary.R
}
