% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{rotate}
\alias{rotate}
\title{rotate cell text}
\usage{
rotate(x, i = NULL, j = NULL, rotation, align = "center", part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{rotation}{one of "lrtb", "tbrl", "btlr"}

\item{align}{vertical alignment of paragraph within cell,
one of "center" or "top" or "bottom".}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
apply a rotation to cell text
}
\details{
One common case is to rotate text to minimise column space. When rotating,
paragraph alignments will remain the same and often right aligned (
with an effect of top aligned when rotated). Use
\code{align(..., align = "center")} to center rotated text.

When function \code{autofit} is used, the rotation will be
ignored.
}
\examples{
ft <- flextable(head(iris))
ft <- rotate(ft, rotation = "tbrl", part = "header", align = "center")
ft <- align(ft, align = "center")
ft <- autofit(ft)
ft <- height(ft, height = max(dim_pretty(ft, part = "header")$widths), part = "header")
}
