% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstate.R
\name{simfinal_fmsm}
\alias{simfinal_fmsm}
\title{Simulate and summarise final outcomes from a flexible parametric multi-state
model}
\usage{
simfinal_fmsm(
  x,
  newdata = NULL,
  probs = c(0.025, 0.5, 0.975),
  t = 1000,
  M = 1e+05,
  B = 0,
  cores = NULL
)
}
\arguments{
\item{x}{Object returned by \code{\link{fmsm}}, representing a multi-state
model formed from transition-specific time-to-event models fitted by
\code{\link{flexsurvreg}}.}

\item{newdata}{Data frame of covariate values, with one column per
covariate, and one row per alternative value.}

\item{probs}{Quantiles to calculate, by default, \code{c(0.025, 0.5, 0.975)}
for a median and 95\% interval.}

\item{t}{Maximum time to simulate to, passed to \code{\link{sim.fmsm}}, so
that the summaries are taken from the subset of individuals in the
simulated data who are in the absorbing state at this time.}

\item{M}{Number of individuals to simulate.}

\item{B}{Number of simulations to use to calculate 95\% confidence intervals
based on the asymptotic normal distribution of the basic parameter
estimates. If \code{B=0} then no intervals are calculated.}

\item{cores}{Number of processor cores to use.  If \code{NULL} (the default)
then a single core is used.}
}
\value{
A tidy data frame with rows for each combination of covariate values
  and quantity of interest.  The quantity of interest is identified in the
  column \code{quantity}, and the value of the quantity is in \code{val},
  with additional columns \code{lower} and \code{upper} giving 95\%
  confidence intervals for the quantity, if \code{B>0}.
}
\description{
Estimates the probability of each final outcome ("absorbing" state), and the
mean and quantiles of the time to that outcome for people who experience it,
by simulating a large sample of individuals from the model.  This can be used
for both Markov and semi-Markov models.
}
\details{
For a competing risks model, i.e. a model defined by just one starting state
and multiple destination states representing competing events, this returns
the probability governing the next event that happens, and the distribution 
of the time to each event conditionally on that event happening.
}
