% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/P.pred.R
\name{P.pred}
\alias{P.pred}
\title{Predict and plot the transition probabilities}
\usage{
P.pred(object, newdata, get.CI = TRUE,
       n.sim.CI = 1000, prob.lev = 0.05,
       plot.P = FALSE, which.plots = NULL,
       rug = FALSE, ...)
}
\arguments{
\item{object}{Fitted model object.}

\item{newdata}{Dataframe containing the profile for which one wished to obtain the predicted transition probabilities.}

\item{get.CI}{Whether to compute the confidence intervals.}

\item{n.sim.CI}{Number of simulations to be used for confidence intervals computation.}

\item{prob.lev}{Probability level of confidence intervals.}

\item{plot.P}{Whether to output plots of transition probabilities.}

\item{which.plots}{Number between 1 and the maximum number of non-null transition probabilities. This can be used if only some plots are to be plotted.}

\item{rug}{Whether to include a rugplot of the observed transition times.}

\item{...}{Other graphical arguments.}
}
\value{
Estimated transition probabilities (and confidence intervals). \tabular{ll}{
\code{P.pred} \tab Predicted transition probability matrix corresponding to the time horizon specified in \code{newdata}. This is a \code{nstates x nstates} matrix. \cr
\tab \cr
\code{P.CI.lower} \tab Matrix containing the lower bounds of the confidence intervals for the predicted transition probability matrix.  \cr
\tab \cr
\code{P.CI.upper} \tab Matrix containing the upper bounds of the confidence intervals for the predicted transition probability matrix.  \cr
\tab \cr
\code{P.hist} \tab List of predicted transition probability matrices computed at each time point specified in \code{newdata}. This is a \code{nstates x nstates x n.pred} array, where \code{n.pred} is the number of rows in \code{newdata}. \cr
\tab \cr
\code{P.CI.lower.hist} \tab List of matrices containing the lower bounds of the confidence intervals for each predicted transition probability matrix in \code{P.hist}.  \cr
\tab \cr
\code{P.CI.upper.hist} \tab List of matrices containing the upper bounds of the confidence intervals for each predicted transition probability matrix in \code{P.hist}.  \cr
\tab \cr
\code{full.X} \tab Full design matrix corresponding to the \code{newdata} provided. \cr
\tab \cr
\code{P.sim.hist} \tab List of transition probability matrices simulated to obtain the confidence intervals at each time point from \code{newdata}. May be useful to quickly obtain intervals for a different confidence level. \cr
}
}
\description{
Function to predict and plot the estimated transition probabilities (and confidence intervals).
}
\seealso{
\code{\link{fmsm}}
}
