%%
%% This is file `vignette.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% jss.dtx  (with options: `class')
%% 
%% IMPORTANT NOTICE:
%% 
%% For the copyright see the source file.
%% 
%% This is a modified version of jss.cls.
%% 
%% Any modified versions of this file must be renamed
%% with new filenames distinct from jss.cls.
%% 
%% For distribution of the original source see the terms
%% for copying and modification in the file jss.dtx.
%% 
%% This generated file may be distributed as long as the
%% original source files, as listed above, are part of the
%% same distribution. (The sources need not necessarily be
%% in the same archive or directory.)
\def\fileversion{0.1}
\def\filename{vignette}
\def\filedate{200/14/12}
%%
%% Package `vignette' to use with LaTeX2e for modified JSS publications
%% Original version jss.cls:
%%   http://www.jstatsoft.org/
%% Copyright (C) 2004 Achim Zeileis
%% Please report errors to Achim.Zeileis@wu-wien.ac.at
%%
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{vignette}[\filedate\space\fileversion\space modification of jss class originally by Achim Zeileis]
%% options
\newif\if@JSS
\@JSSfalse
\DeclareOption{JSS}{\@JSStrue}
\ProcessOptions
\LoadClass[11pt,a4paper,twoside]{article}
%% required packages
\RequirePackage{graphicx,a4wide,color,hyperref,ae,fancyvrb}
\RequirePackage[utf8]{inputenc}
%% bibliography
\usepackage[authoryear,round,longnamesfirst]{natbib}
\bibpunct{(}{)}{;}{a}{}{,}
\bibliographystyle{jss}
%% paragraphs
\setlength{\parskip}{0.7ex plus0.1ex minus0.1ex}
\setlength{\parindent}{0em}
%% commands
\let\code=\texttt
\let\proglang=\textsf
\newcommand{\pkg}[1]{{\normalfont\fontseries{b}\selectfont #1}}
\newcommand{\email}[1]{\href{mailto:#1}{\normalfont\texttt{#1}}}
\newcommand{\E}{\mathsf{E}}
\newcommand{\VAR}{\mathsf{VAR}}
\newcommand{\COV}{\mathsf{COV}}
\newcommand{\Prob}{\mathsf{P}}
%% for all publications
\newcommand{\Address}[1]{\def\@Address{#1}}
\newcommand{\Plaintitle}[1]{\def\@Plaintitle{#1}}
\newcommand{\Shorttitle}[1]{\def\@Shorttitle{#1}}
\newcommand{\Plainauthor}[1]{\def\@Plainauthor{#1}}
\newcommand{\Volume}[1]{\def\@Volume{#1}}
\newcommand{\Year}[1]{\def\@Year{#1}}
\newcommand{\Month}[1]{\def\@Month{#1}}
\newcommand{\Issue}[1]{\def\@Issue{#1}}
\newcommand{\Submitdate}[1]{\def\@Submitdate{#1}}
%% for articles
\newcommand{\subtitle}[1]{\def\@subtitle{#1}}
\newcommand{\Acceptdate}[1]{\def\@Acceptdate{#1}}
\newcommand{\Abstract}[1]{\def\@Abstract{#1}}
\newcommand{\Keywords}[1]{\def\@Keywords{#1}}
\newcommand{\Plainkeywords}[1]{\def\@Plainkeywords{#1}}
%% for internal use
\newcommand{\Seriesname}[1]{\def\@Seriesname{#1}}
\newcommand{\Hyperauthor}[1]{\def\@Hyperauthor{#1}}
\newcommand{\Footername}[1]{\def\@Footername{#1}}
\newcommand{\Firstdate}[1]{\def\@Firstdate{#1}}
\newcommand{\Seconddate}[1]{\def\@Seconddate{#1}}
%% defaults
\author{Firstname Lastname\\Affiliation}
\title{Title}
\subtitle{}
\Abstract{---!!!---an abstract is required---!!!---}
\Plainauthor{\@author}
\Volume{VV}
\Year{YYYY}
\Month{MMMMMM}
\Issue{II}
\Submitdate{yyyy-mm-dd}
\Acceptdate{yyyy-mm-dd}
\Address{
  Firstname Lastname\\
  Affiliation\\
  Address, Country\\
  E-mail: \email{name@address}\\
  URL: \url{http://link/to/webpage/}
}

\Seriesname{Issue}
\Plaintitle{\@title}
\Shorttitle{\@title}
\Plainkeywords{\@Keywords}

\Hyperauthor{\@Plainauthor}
\Keywords{---!!!---at least one keyword is required---!!!---}
\Footername{Affiliation}
\Firstdate{\textit{Submitted:} \@Submitdate}
\Seconddate{\textit{Accepted:} \@Acceptdate}
%% Sweave(-like)
\DefineVerbatimEnvironment{Sinput}{Verbatim}{fontshape=sl}
\DefineVerbatimEnvironment{Soutput}{Verbatim}{}
\DefineVerbatimEnvironment{Scode}{Verbatim}{fontshape=sl}
\newenvironment{Schunk}{}{}
\DefineVerbatimEnvironment{Code}{Verbatim}{}
\DefineVerbatimEnvironment{CodeInput}{Verbatim}{fontshape=sl}
\DefineVerbatimEnvironment{CodeOutput}{Verbatim}{}
\newenvironment{CodeChunk}{}{}
\setkeys{Gin}{width=0.8\textwidth}
%% new \maketitle
\def\maketitle{
  \begingroup
  \def\thefootnote{\fnsymbol{footnote}}
  \def\@makefnmark{\hbox to 0pt{$^{\@thefnmark}$\hss}}
  \long\def\@makefntext##1{\parindent 1em\noindent
    \hbox to1.8em{\hss $\m@th ^{\@thefnmark}$}##1}
  \@maketitle \@thanks
  \endgroup
     \setcounter{footnote}{0}
   \thispagestyle{empty}
   \markboth{\centerline{\@Shorttitle}}{\centerline{\@Hyperauthor}}
   \pagestyle{myheadings}
   
   \let\maketitle\relax \let\@maketitle\relax
   \gdef\@thanks{}\gdef\@author{}\gdef\@title{}\let\thanks\relax
 }
 
 \def\@maketitle{\vbox{
     {\centering
       {\LARGE\bf \@title\par}
     \def\And{\end{tabular}\hfil\linebreak[0]\hfil
     \begin{tabular}[t]{c}\large\bf\rule{\z@}{24pt}\ignorespaces}%
     \begin{tabular}[t]{c}\large\bf\rule{\z@}{24pt}\@author\end{tabular}%
     \vskip 0.1in minus 0.1in
     {\large \@subtitle\par}
     \vskip 0.1in minus 0.1in
     \hrule
     \begin{abstract}
       \@Abstract
   \end{abstract}}
 \textit{Keywords}:~\@Keywords.
 \vskip 0.1in minus 0.05in
 \hrule
 \vskip 0.2in minus 0.1in
}}
%% sections, subsections, and subsubsections
\newlength{\preXLskip}
\newlength{\preLskip}
\newlength{\preMskip}
\newlength{\preSskip}
\newlength{\postMskip}
\newlength{\postSskip}
\setlength{\preXLskip}{1.8\baselineskip plus 0.5ex minus 0ex}
\setlength{\preLskip}{1.5\baselineskip plus 0.3ex minus 0ex}
\setlength{\preMskip}{1\baselineskip plus 0.2ex minus 0ex}
\setlength{\preSskip}{.8\baselineskip plus 0.2ex minus 0ex}
\setlength{\postMskip}{.5\baselineskip plus 0ex minus 0.1ex}
\setlength{\postSskip}{.3\baselineskip plus 0ex minus 0.1ex}

\newcommand{\jsssec}[2][default]{\vskip \preXLskip%
  \pdfbookmark[1]{#1}{Section.\thesection.#1}%
  \refstepcounter{section}%
  \centerline{\textbf{\Large \thesection. #2}} \nopagebreak
  \vskip \postMskip \nopagebreak}
\newcommand{\jsssecnn}[1]{\vskip \preXLskip%
  \centerline{\textbf{\Large #1}} \nopagebreak
  \vskip \postMskip \nopagebreak}

\newcommand{\jsssubsec}[2][default]{\vskip \preMskip%
  \pdfbookmark[2]{#1}{Subsection.\thesubsection.#1}%
  \refstepcounter{subsection}%
  \textbf{\large \thesubsection. #2} \nopagebreak
  \vskip \postSskip \nopagebreak}
\newcommand{\jsssubsecnn}[1]{\vskip \preMskip%
  \textbf{\large #1} \nopagebreak
  \vskip \postSskip \nopagebreak}

\newcommand{\jsssubsubsec}[2][default]{\vskip \preSskip%
  \pdfbookmark[3]{#1}{Subsubsection.\thesubsubsection.#1}%
  \refstepcounter{subsubsection}%
  {\large \textit{#2}} \nopagebreak
  \vskip \postSskip \nopagebreak}
\newcommand{\jsssubsubsecnn}[1]{\vskip \preSskip%
  {\textit{\large #1}} \nopagebreak
  \vskip \postSskip \nopagebreak}

\newcommand{\jsssimplesec}[2][default]{\vskip \preLskip%
%%  \pdfbookmark[1]{#1}{Section.\thesection.#1}%
  \refstepcounter{section}%
  \textbf{\large #1} \nopagebreak
  \vskip \postSskip \nopagebreak}
\newcommand{\jsssimplesecnn}[1]{\vskip \preLskip%
  \textbf{\large #1} \nopagebreak
  \vskip \postSskip \nopagebreak}

\renewcommand{\section}{\secdef \jsssec \jsssecnn}
\renewcommand{\subsection}{\secdef \jsssubsec \jsssubsecnn}
\renewcommand{\subsubsection}{\secdef \jsssubsubsec \jsssubsubsecnn}
%% footer
\if@JSS
\newlength{\footerskip}
\setlength{\footerskip}{2.5\baselineskip plus 2ex minus 0.5ex}

\newcommand{\makefooter}{%
  \vspace{\footerskip}

  \begin{samepage}
  \textbf{\large \@Footername: \nopagebreak}\\[.3\baselineskip] \nopagebreak
  \@Address \nopagebreak
  \vfill
  Original publication:\\
  \hrule \nopagebreak
  \vspace{.1\baselineskip}
  {\fontfamily{pzc} \fontsize{13}{15} \selectfont Journal of Statistical Software}
  \hfill
  \@Firstdate\\ \nopagebreak
  {\@Month{} \@Year, Volume~\@Volume, \@Seriesname~\@Issue.}
  \hfill
  \@Seconddate\\ \nopagebreak
  \url{http://www.jstatsoft.org/} \nopagebreak
  \vspace{.3\baselineskip}
  \hrule
  \end{samepage}
}
\fi
%% colors
\definecolor{Red}{rgb}{0.7,0,0}
\definecolor{Blue}{rgb}{0,0,0.8}
\hypersetup{%
  hyperindex = {true},
  colorlinks = {true},
  linktocpage = {true},
  plainpages = {false},
  linkcolor = {Blue},
  citecolor = {Blue},
  urlcolor = {Red},
  pdfstartview = {Fit},
  pdfpagemode = {UseOutlines},
  pdfview = {XYZ null null null}
}
\AtBeginDocument{
  \hypersetup{%
    pdfauthor = {\@Hyperauthor},
    pdftitle = {\@Plaintitle},
    pdfkeywords = {\@Plainkeywords}
  }
}
\AtBeginDocument{\maketitle}
\if@JSS
\AtEndDocument{\makefooter}
\fi
\endinput
%%
%% End of file `vignette.cls'.
