% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valuebox.R
\name{valueBox}
\alias{valueBox}
\title{Create a value box component for a dashboard.}
\usage{
valueBox(value, caption = NULL, icon = NULL, color = NULL, href = NULL)
}
\arguments{
\item{value}{The value to display in the box. Usually a number or short text.}

\item{caption}{The caption to display beneath the value.}

\item{icon}{An icon for the box (e.g. "fa-comments")}

\item{color}{Background color for the box. This can be one of the built-in
background colors ("primary", "info", "success", "warning", "danger") or
any valid CSS color value.}

\item{href}{An optional URL to link to. Note that this can be an anchor of
another dashboard page (e.g. "#details").}
}
\description{
A value box displays a value (usually a number) in large text, with a smaller
caption beneath, and a large icon on the right side.
}
\details{
See the flexdashboard website for additional documentation:
 \href{http://rmarkdown.rstudio.com/flexdashboard/using.html#value_boxes}{http://rmarkdown.rstudio.com/flexdashboard/using.html#value_boxes}
}
\examples{
library(flexdashboard)

valueBox(42, caption = "Errors", icon="fa-thumbs-down")
valueBox(107, caption = "Trials", icon="fa-tag")
valueBox(247, caption = "Connections", icon="fa-random")

}
