% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_getSiblings}
\alias{fxml_getSiblings}
\title{Siblings of an XML element}
\usage{
fxml_getSiblings(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
The IDs (\code{xmlflat.df$elemid.}) of the siblings of the XML element with ID \code{elemid}. If no siblings exist, \code{NULL} is returned.
}
\description{
Returns the siblings of an XML element, i.e. the elements on the same hierarchical level.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Get all the siblings (elements on the same hierarchy level) of the XML element with ID 4
# (xml.dataframe$elemid. ==  4)
fxml_getSiblings(xml.dataframe, 4)
}
\seealso{
\code{\link{fxml_hasSiblings}}, \code{\link{fxml_getSiblings}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
