% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_hasAttributes}
\alias{fxml_hasAttributes}
\title{Attributes of XML elements}
\usage{
fxml_hasAttributes(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
\code{TRUE} if the the XML element with ID \code{elemid} has at least one attribute, \code{FALSE} otherwise.
}
\description{
Determines if an XML element has any attributes.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Check if the XML element with ID 4 (xml.dataframe$elemid. ==  4) has any attributes
fxml_hasAttributes(xml.dataframe, 4)

}
\seealso{
\code{\link{fxml_getAttribute}}, \code{\link{fxml_numAttributes}}, \code{\link{fxml_getAttributesAll}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
