% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{remove_rows}
\alias{remove_rows}
\alias{remove_rows.pivot_table}
\title{Remove rows from a pivot table}
\usage{
remove_rows(pt, r)

\method{remove_rows}{pivot_table}(pt, r)
}
\arguments{
\item{pt}{A \code{pivot_table} object.}

\item{r}{A vector of numbers, row numbers.}
}
\value{
A \code{pivot_table} object.
}
\description{
Remove the rows whose numbers are indicated from the pivot table represented
by the object.
}
\details{
A pivot table should only contain label rows and columns, and an array of
values, usually numeric data.

All rows not belonging to the pivot table must be removed. It is common to
find rows with header or footer information, which must be removed.
}
\examples{

pt <- pt_ex |> remove_rows(1)

pt <- pt_ex |> remove_rows(c(1, 8, 14, 19, 25, 26))

}
\seealso{
\code{\link{pivot_table}}

Other pivot table transformation functions: 
\code{\link{extract_labels}()},
\code{\link{fill_labels}()},
\code{\link{fill_values}()},
\code{\link{remove_agg}()},
\code{\link{remove_bottom}()},
\code{\link{remove_cols}()},
\code{\link{remove_empty}()},
\code{\link{remove_k}()},
\code{\link{remove_left}()},
\code{\link{remove_right}()},
\code{\link{remove_top}()},
\code{\link{replace_dec}()},
\code{\link{unpivot}()}
}
\concept{pivot table transformation functions}
