% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_light_global_surrogate.R
\name{plot.light_global_surrogate}
\alias{plot.light_global_surrogate}
\title{Plot Global Surrogate Trees}
\usage{
\method{plot}{light_global_surrogate}(x, type = 5, auto_main = TRUE, mfrow = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{light_global_surrogate}.}

\item{type}{Plot type, see help of \code{rpart.plot}. Default is 5.}

\item{auto_main}{Automatic plot titles (only if multiple trees are shown in the same figure).}

\item{mfrow}{If multiple trees are shown in the same figure: what value of \code{mfrow} to use in \code{par}?}

\item{...}{Further arguments passed to \code{rpart.plot}.}
}
\value{
An object of class \code{ggplot2}.
}
\description{
Using \code{rpart.plot}, trees fitted by \code{light_global_surrogate} are visualized.
}
\examples{
fit1 <- lm(Sepal.Length ~ ., data = iris)
fit2 <- lm(Sepal.Length ~ Petal.Length, data = iris)
fl1 <- flashlight(model = fit1, label = "full")
fl2 <- flashlight(model = fit2, label = "partial")
fls <- multiflashlight(list(fl1, fl2), data = iris, y = "Sepal.Length")
surr <- light_global_surrogate(fls)
plot(surr, cex = 0.6)
plot(light_global_surrogate(fls$full))
plot(light_global_surrogate(fls$full, by = "Species"))
}
\seealso{
\code{\link{light_global_surrogate}}.
}
