% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R
\name{weights.fixest}
\alias{weights.fixest}
\title{Extracts the weights from a fixest object}
\usage{
\method{weights}{fixest}(object, ...)
}
\arguments{
\item{object}{A \code{fixest} object.}

\item{...}{Not currently used.}
}
\value{
Returns a vector of the same length as the number of observations in the original data set. Ignored observations due to NA or perfect fit are re-introduced and their weights set to NA.
}
\description{
Simply extracts the weights used to estimate a \code{fixest} model.
}
\examples{

est = feols(Petal.Length ~ Petal.Width, iris, weights = ~as.integer(Sepal.Length) - 3.99)
weights(est)

}
\seealso{
\code{\link[fixest]{feols}}, \code{\link[fixest]{fepois}}, \code{\link[fixest]{feglm}}, \code{\link[fixest]{fenegbin}}, \code{\link[fixest]{feNmlm}}.
}
