% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deprecated_funs.R
\name{errbar}
\alias{errbar}
\title{Plots confidence intervals}
\usage{
errbar(estimate, sd, ci_low, ci_top, x, x.shift = 0, w = 0.1,
  ci_level = 0.95, style = c("bar", "interval", "tube"), add = FALSE,
  col = 1, bar.col = col, bar.lwd = par("lwd"), bar.lty,
  grid = TRUE, grid.par = list(lty = 1), bar.join = FALSE,
  only.params = FALSE, ...)
}
\arguments{
\item{estimate}{Numeric vector. The point estimates.}

\item{sd}{The standard errors of the estimates. It may be missing.}

\item{ci_low}{If \code{sd} is not provided, the lower bound of the confidence interval. For each estimate.}

\item{ci_top}{If \code{sd} is not provided, the upper bound of the confidence interval. For each estimate.}

\item{x}{The value of the x-axis. If missing, the names of the argument \code{estimate} is used.}

\item{x.shift}{Shifts the confidence intervals bars to the left or right, depending on the value of \code{x.shift}. Default is 0.}

\item{w}{The width of the confidence intervals.}

\item{ci_level}{Scalar between 0 and 1: the level of the CI. By default it is equal to 0.95.}

\item{style}{If \dQuote{interval}: it plots a confidence interval. If \dQuote{bar}, it plots simply error bars. If \dQuote{tube}: as interval, but with a grayed area.}

\item{add}{Default is \code{FALSE}, if the intervals are to be added to an existing graph. Note that if it is the case, then the argument \code{x} MUST be numeric.}

\item{col}{Color of the point estimate and of the line joining them (if \code{style = "interval"}).}

\item{bar.col}{Color of the bars of the confidence interval. Defaults to \code{col}.}

\item{bar.lwd}{Line width of the confidence intervals, defaults to \code{1}.}

\item{bar.lty}{Line type of the confidence intervals, defaults to \code{1} for \code{style = "bar"} and to \code{2} for \code{style = "interval"}.}

\item{grid}{Whether to add an horizontal grid. Default is \code{TRUE}.}

\item{grid.par}{Graphical parameters used when plotting the grid in the background. Default is \code{list(lty=1)}.}

\item{bar.join}{Logical, default is \code{FALSE}. Whether to join the dots when \code{style = "bar"}.}

\item{only.params}{Logical, default is \code{FALSE}. If \code{TRUE}: no graph is plotted, only the \code{ylim} is returned. Useful to stack estimates from different estimations in the same graph.}

\item{...}{Other arguments to be passed to the function \code{plot} or \code{lines} (if \code{add = TRUE}).}
}
\description{
This function draws confidence intervals in a graph.
}
\examples{
a = rnorm(100)
b = 0.5*a + rnorm(100)
c = -0.5*b + rnorm(100)

est = summary(lm(a ~ c + b))

errbar(est$coefficients, x.shift = -.2)

errbar(est$coefficients, x.shift = .2, add = TRUE, col = 2, bar.lty = 2, pch=15)

}
\seealso{
\code{\link{fixest-deprecated}}
}
\author{
Laurent Berge
}
\keyword{internal}
