% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCOV.R
\name{vcov_cluster}
\alias{vcov_cluster}
\title{Clustered VCOV}
\usage{
vcov_cluster(x, cluster = NULL, ssc = NULL)
}
\arguments{
\item{x}{A \code{fixest} object.}

\item{cluster}{Either i) a character vector giving the names of the variables onto which to cluster, or ii) a formula giving those names, or iii) a vector/list/data.frame giving the hard values of the clusters. Note that in cases i) and ii) the variables are fetched directly in the data set used for the estimation.}

\item{ssc}{An object returned by the function \code{\link{ssc}}. It specifies how to perform the small sample correction.}
}
\value{
If the first argument is a \code{fixest} object, then a VCOV is returned (i.e. a symmetric matrix).

If the first argument is not a \code{fixest} object, then a) implicitly the arguments are shifted to the left (i.e. \code{vcov_cluster(~var1 + var2)} is equivalent to \code{vcov_cluster(cluster = ~var1 + var2)}) and b) a VCOV-\emph{request} is returned and NOT a VCOV. That VCOV-request can then be used in the argument \code{vcov} of various \code{fixest} functions (e.g. \code{\link{vcov.fixest}} or even in the estimation calls).
}
\description{
Computes the clustered VCOV of \code{fixest} objects.
}
\examples{

base = iris
names(base) = c("y", "x1", "x2", "x3", "species")
base$clu = rep(1:5, 30)

est = feols(y ~ x1, base)

# VCOV: using a formula giving the name of the clusters
vcov_cluster(est, ~species + clu)

# works as well with a character vector
vcov_cluster(est, c("species", "clu"))

# you can also combine the two with '^'
vcov_cluster(est, ~species^clu)

#
# Using VCOV requests
#

# per se: pretty useless...
vcov_cluster(~species)

# ...but VCOV-requests can be used at estimation time:
# it may be more explicit than...
feols(y ~ x1, base, vcov = vcov_cluster("species"))

# ...the equivalent, built-in way:
feols(y ~ x1, base, vcov = ~species)

# The argument vcov does not accept hard values,
# so you can feed them with a VCOV-request:
feols(y ~ x1, base, vcov = vcov_cluster(rep(1:5, 30)))


}
\references{
Cameron AC, Gelbach JB, Miller DL (2011). "Robust Inference with Multiway Clustering." \emph{Journal of Business & Economic Statistics}, 29(2), 238-249. doi:10.1198/jbes.2010.07136.
}
\author{
Laurent Berge
}
