% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.psFit.R
\name{confint.psFit}
\alias{confint.psFit}
\title{S3 confint method for objects of class psFit}
\usage{
\method{confint}{psFit}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{an object of class \code{psFit}---see fitDist for more details}

\item{parm}{added for compatibility. Should be left empty as it is ignored.}

\item{level}{the confidence level required---restricted to [0.75, 1)}

\item{...}{in theory other parameters to be passed to \code{confint}, but in
reality ignored.}
}
\value{
a list with two items: \code{wald} and \code{prof} containing the
  Wald and profile likelihood confidence intervals respectively for the shape
  parameter of the fitted Zeta distribution. In general these should be
  relatively close to each other. **NOTE** These values are for the
  \pkg{VGAM} parameterisation of the Zeta distribution which uses
  \eqn{s^\prime = s - 1}{s' = s - 1}. This means they can be used without
  alteration in \code{\link[VGAM]{dzeta}}.
}
\description{
S3 confint method for objects of class psFit
}
\examples{
data(Psurveys)
roux = Psurveys$roux
fit = fitDist(roux)
confint(fit)

}
