% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kumaraswamy.R
\name{dKUM}
\alias{dKUM}
\title{Kumaraswamy Distribution}
\usage{
dKUM(p,a,b)
}
\arguments{
\item{p}{vector of probabilities.}

\item{a}{single value for shape parameter alpha representing as a.}

\item{b}{single value for shape parameter beta representing as b.}
}
\value{
The output of \code{dKUM} gives a list format consisting

\code{pdf}             probability density values in vector form.

\code{mean}            mean of the Kumaraswamy distribution.

\code{var}             variance of the Kumaraswamy distribution.
}
\description{
These functions provide the ability for generating probability density values,
cumulative probability density values and moment about zero values for the
Kumaraswamy Distribution bounded between [0,1].
}
\details{
The probability density function and cumulative density function of a unit
bounded Kumaraswamy Distribution with random variable P are given by

\deqn{g_{P}(p)= abp^{a-1}(1-p^a)^{b-1} } ;        \eqn{0 \le p \le 1}
\deqn{G_{P}(p)= 1-(1-p^a)^b} ;                   \eqn{0 \le p \le 1}
\deqn{a,b > 0}

The mean and the variance are denoted by
\deqn{E[P]= bB(1+\frac{1}{a},b)}
\deqn{var[P]= bB(1+\frac{2}{a},b)-(bB(1+\frac{1}{a},b))^2}

The moments about zero is denoted as
\deqn{E[P^r]= bB(1+\frac{r}{a},b)}
\eqn{r = 1,2,3,...}

Defined as \eqn{B(a,b)} is the beta function.

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further.
}
\examples{
#plotting the random variables and probability values
col <- rainbow(4)
a <- c(1,2,5,10)
plot(0,0,main="Probability density graph",xlab="Random variable",ylab="Probability density values",
xlim = c(0,1),ylim = c(0,6))
for (i in 1:4)
{
lines(seq(0,1,by=0.01),dKUM(seq(0,1,by=0.01),a[i],a[i])$pdf,col = col[i])
}

dKUM(seq(0,1,by=0.01),2,3)$pdf   #extracting the probability values
dKUM(seq(0,1,by=0.01),2,3)$mean  #extracting the mean
dKUM(seq(0,1,by=0.01),2,3)$var   #extracting the variance

#plotting the random variables and cumulative probability values
col <- rainbow(4)
a <- c(1,2,5,10)
plot(0,0,main="Cumulative density graph",xlab="Random variable",ylab="Cumulative density values",
xlim = c(0,1),ylim = c(0,1))
for (i in 1:4)
{
lines(seq(0,1,by=0.01),pKUM(seq(0,1,by=0.01),a[i],a[i]),col = col[i])
}

pKUM(seq(0,1,by=0.01),2,3)    #acquiring the cumulative probability values

mazKUM(1.4,3,2)               #acquiring the moment about zero values
mazKUM(2,2,3)-mazKUM(1,2,3)^2  #acquiring the variance for a=2,b=3

#only the integer value of moments is taken here because moments cannot be decimal
mazKUM(1.9,5.5,6)

}
\references{
\insertRef{kumaraswamy1980generalized}{fitODBOD}
\insertRef{jones2009kumaraswamy}{fitODBOD}
}
