% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gbeta1.R
\name{fitMcGBB}
\alias{fitMcGBB}
\title{Fitting the McDonald Generalized Beta  Binomial distribution when binomial
random variable, frequency and shape parameters are given}
\usage{
fitMcGBB(x,obs.freq,a,b,c)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{obs.freq}{vector of frequencies.}

\item{a}{single value for shape parameter alpha representing a.}

\item{b}{single value for shape parameter beta representing b.}

\item{c}{single value for shape parameter gamma representing c.}
}
\value{
The output of \code{fitMcGBB} gives the class format \code{fitMB} and \code{fit} consisting a list

\code{bin.ran.var} binomial random variables.

\code{obs.freq} corresponding observed frequencies.

\code{exp.freq} corresponding expected frequencies.

\code{statistic} chi-squared test statistics.

\code{df} degree of freedom.

\code{p.value} probability value by chi-squared test statistic.

\code{fitMB} fitted values of \code{dMcGBB}.

\code{NegLL} Negative Log Likelihood value.

\code{a} estimated value for alpha parameter as a.

\code{b} estimated value for beta parameter as b.

\code{c} estimated value for gamma parameter as c.

\code{AIC} AIC value.

\code{over.dis.para} over dispersion value.

\code{call} the inputs of the function.

Methods \code{summary}, \code{print}, \code{AIC}, \code{residuals} and \code{fitted} can be used to
extract specific outputs.
}
\description{
The function will fit the McDonald Generalized Beta  Binomial Distribution
when random variables, corresponding frequencies and shape parameters are given. It will provide
the expected frequencies, chi-squared test statistics value, p value, degree of freedom
and over dispersion value so that it can be seen if this distribution fits the data.
}
\details{
\deqn{0 < a,b,c}
\deqn{x = 0,1,2,...}
\deqn{obs.freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions necessary
error messages will be provided to go further.
}
\examples{
No.D.D <- 0:7       #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)          #assigning the corresponding frequencies

\dontrun{
#estimating the parameters using maximum log likelihood value and assigning it
parameters <- EstMLEMcGBB(x=No.D.D,freq=Obs.fre.1,a=0.1,b=0.1,c=3.2)

aMcGBB <- bbmle::coef(parameters)[1]         #assigning the estimated a
bMcGBB <- bbmle::coef(parameters)[2]         #assigning the estimated b
cMcGBB <- bbmle::coef(parameters)[3]         #assigning the estimated c

#fitting when the random variable,frequencies,shape parameter values are given.
results <- fitMcGBB(No.D.D,Obs.fre.1,aMcGBB,bMcGBB,cMcGBB)
results

#extracting the expected frequencies
fitted(results)

#extracting the residuals
residuals(results)
     }

}
\references{
Manoj, C., Wijekoon, P. & Yapa, R.D., 2013. The McDonald Generalized Beta-Binomial Distribution: A New
Binomial Mixture Distribution and Simulation Based Comparison with Its Nested Distributions in Handling
Overdispersion. International Journal of Statistics and Probability, 2(2), pp.24-41.

Available at: \url{http://www.ccsenet.org/journal/index.php/ijsp/article/view/23491}.

Janiffer, N.M., Islam, A. & Luke, O., 2014. Estimating Equations for Estimation of Mcdonald Generalized
Beta - Binomial Parameters. , (October), pp.702-709.

Roozegar, R., Tahmasebi, S. & Jafari, A.A., 2015. The McDonald Gompertz Distribution: Properties and Applications.
Communications in Statistics - Simulation and Computation, (May), pp.0-0.

Available at: \url{http://www.tandfonline.com/doi/full/10.1080/03610918.2015.1088024}.
}
\seealso{
\code{\link[bbmle]{mle2}}
}
