% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\name{BODextract}
\alias{BODextract}
\title{Binomial Data Extraction from Raw data}
\usage{
BODextract(data)
}
\arguments{
\item{data}{vector of observations}
}
\value{
The output of \code{BODextract} gives a list format consisting

\code{RV} binomial random variables in vector form

\code{Freq}  corresponding frequencies in vector form
}
\description{
The below function has the ability to extract from the raw data to Binomial Outcome Data. This
function simplifies the data into more presentable way to the user.
}
\details{
\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further
}
\examples{
datapoints=sample(0:10,340,replace=TRUE) #creating a sample set of observations
BODextract(datapoints)                   #extracting binomial outcome data from observations
Random.variable=BODextract(datapoints)$RV #extracting the binomial random variables

}
