% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolocate.R
\name{coords_to_fips}
\alias{coords_to_fips}
\alias{coords_to_fips.sf}
\alias{coords_to_fips.sfc}
\alias{coords_to_fips.sfg}
\alias{coords_to_fips.list}
\alias{coords_to_fips.data.frame}
\alias{coords_to_fips.matrix}
\alias{coords_to_fips.character}
\alias{coords_to_fips.numeric}
\title{Associate a set of coordinates to FIPS codes}
\usage{
coords_to_fips(x, ...)

\method{coords_to_fips}{sf}(x, ...)

\method{coords_to_fips}{sfc}(x, ...)

\method{coords_to_fips}{sfg}(x, ...)

\method{coords_to_fips}{list}(x, ...)

\method{coords_to_fips}{data.frame}(x, coords = c(1, 2), ...)

\method{coords_to_fips}{matrix}(x, coords = c(1, 2), ...)

\method{coords_to_fips}{character}(x, y, ...)

\method{coords_to_fips}{numeric}(x, y, ...)
}
\arguments{
\item{x}{\code{data.frame}, \code{matrix}, \code{sf}/\code{sfc}/\code{sfg} object,
or longitude in \emph{EPSG:4326}}

\item{...}{Named arguments passed on to methods}

\item{coords}{Coordinates columns if \code{x} is a \code{data.frame} or \code{matrix}.}

\item{y}{Latitude in \emph{EPSG:4326}}
}
\value{
a \code{character} vector of FIPS codes
}
\description{
Associate a set of coordinates to FIPS codes
}
\examples{
# Some coordinates at UC Santa Barbara
coords_to_fips(x = -119.8696, y = 34.4184)
}
