% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{total_solar_production_used_in_forecast}
\alias{total_solar_production_used_in_forecast}
\title{Total solar production capacity used in the solar power forecast}
\usage{
total_solar_production_used_in_forecast(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains the total solar power production
capacity used in Fingrid's solar power forecast. It is based on the
small scale production statistics gathered by the Energy authority.
It is also updated with estimates based on information that's provided
to Fingrid.
}
\description{
Check https://data.fingrid.fi/en/dataset/total-solar-production-capacity
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- total_solar_production_used_in_forecast(
    start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
