% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{FCRD_reserve_plans_yearly_market}
\alias{FCRD_reserve_plans_yearly_market}
\title{Frequency containment reserves for disturbances, reserve plans in the yearly market}
\usage{
FCRD_reserve_plans_yearly_market(start_time = NA, end_time = NA, user_key = NA)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains the hourly sum of reserve plans
for frequency containment reserve for disturbances upwards regulation
(FCR-D up) in the yearly market. The data will be published 22:45 (EET)
on previous evening.
}
\description{
Check https://data.fingrid.fi/en/dataset/taajuusohjattu-hairioreservi-vuosimarkkinasuunnitelmat
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- FCRD_reserve_plans_yearly_market(
    start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
