% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick_charts.R
\name{map}
\alias{map}
\title{Plot a choropleth map for an indicator}
\usage{
map(data, ons_api, area_code, fill, type = "static", value,
  name_for_label, title = "", subtitle = "", copyright_size = 4)
}
\arguments{
\item{data}{data.frame object to plot using ggplot2 functions}

\item{ons_api}{string; GeoJSON address provided from the ONS geography portal}

\item{area_code}{field containing area codes to join to shape file imported
from ONS API}

\item{fill}{field to be used to determine the colouring of the areas (unquoted)}

\item{type}{string; the output map required. Can be "static" or "interactive"}

\item{value}{field containing variable to be plotted on x axis (unquoted)}

\item{name_for_label}{if interactive map, name of field containing area names
to be used for label (unquoted) - optional}

\item{title}{string; title of chart}

\item{subtitle}{string; text to use as subtitle to graph}

\item{copyright_size}{number; determine size of the copyright text}
}
\value{
a either a static or interactive ggplot choropleth map
}
\description{
Plot a choropleth map for an indicator
}
\examples{
\donttest{
# This example is untested because of the time required to retrieve the data
library(fingertipsR)
library(dplyr)
df <- fingertips_data(90366) \%>\%
        filter(Sex == "Male" &
                       AreaType == "County & UA" &
                       Timeperiod == "2014 - 16")
ons_api <- "https://opendata.arcgis.com/datasets/687f346f5023410ba86615655ff33ca9_4.geojson"

p <- map(df,
         ons_api = ons_api,
         area_code = AreaCode,
         fill = ComparedtoEnglandvalueorpercentiles,
         title = "Life expectancy at birth",
         subtitle = "Males in Upper Tier Local Authorities England")

## For an interactive (leaflet) map
p <- map(df,
         ons_api = ons_api,
         area_code = AreaCode,
         fill = ComparedtoEnglandvalueorpercentiles,
         type = "interactive",
         value = Value,
         name_for_label = AreaName,
         title = "Life expectancy at birth<br>Males within UTLAs in England")
p}
}
\seealso{
Other quick charts: \code{\link{box_plots}},
  \code{\link{compare_areas}},
  \code{\link{compare_indicators}}, \code{\link{overview}},
  \code{\link{population}}, \code{\link{trends}}
}
\concept{quick charts}
