% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findInFiles.R
\name{findInFiles-shiny}
\alias{findInFiles-shiny}
\alias{FIFOutput}
\alias{renderFIF}
\title{Shiny bindings for \code{findInFiles}}
\usage{
FIFOutput(outputId, width = "100\%", height = "400px")

renderFIF(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{a valid CSS unit (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended}

\item{expr}{an expression that generates a '\code{\link{findInFiles}}' widget}

\item{env}{the environment in which to evaluate \code{expr}}

\item{quoted}{logical, whether \code{expr} is a quoted expression (with
\code{quote()})}
}
\value{
\code{FIFOutput} returns an output element that can be included in a
  Shiny UI definition, and \code{renderFIF} returns a
  \code{shiny.render.function} object that can be included in a Shiny server
  definition.
}
\description{
Output and render functions for using \code{findInFiles} within
  Shiny applications and interactive Rmd documents.
}
\examples{
library(findInFiles)
library(shiny)

onKeyDown <- HTML(
  'function onKeyDown(event) {',
  '  var key = event.which || event.keyCode;',
  '  if(key === 13) {',
  '    Shiny.setInputValue(',
  '      "pattern", event.target.value, {priority: "event"}',
  '    );',
  '  }',
  '}'
)

ui <- fluidPage(
  tags$head(tags$script(onKeyDown)),
  br(),
  sidebarLayout(
    sidebarPanel(
      selectInput(
        "ext", "Extension",
        choices = c("R", "js", "css")
      ),
      tags$div(
        class = "form-group shiny-input-container",
        tags$label(
          class = "control-label",
          "Pattern"
        ),
        tags$input(
          type = "text",
          class = "form-control",
          onkeydown = "onKeyDown(event);",
          placeholder = "Press Enter when ready"
        )
      ),
      numericInput(
        "depth", "Depth (set -1 for unlimited depth)",
        value = 0, min = -1, step = 1
      ),
      checkboxInput(
        "wholeWord", "Whole word"
      ),
      checkboxInput(
        "ignoreCase", "Ignore case"
      )
    ),
    mainPanel(
      FIFOutput("results")
    )
  )
)


server <- function(input, output){

  output[["results"]] <- renderFIF({
    req(input[["pattern"]])
    findInFiles(
      ext = isolate(input[["ext"]]),
      pattern = input[["pattern"]],
      depth = isolate(input[["depth"]]),
      wholeWord = isolate(input[["wholeWord"]]),
      ignoreCase = isolate(input[["ignoreCase"]])
    )
  })

}

if(interactive()){
  shinyApp(ui, server)
}
}
