% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finbif-package.R
\docType{package}
\name{finbif-package}
\alias{finbif}
\alias{finbif-package}
\title{finbif: Interface for the 'Finnish Biodiversity Information Facility' API}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

A programmatic interface to the 'Finnish Biodiversity Information Facility' ('FinBIF') API (\url{https://api.laji.fi}). 'FinBIF' aggregates Finnish biodiversity data from multiple sources in a single open access portal for researchers, citizen scientists, industry and government. 'FinBIF' allows users of biodiversity information to find, access, combine and visualise data on Finnish plants, animals and microorganisms. The 'finbif' package makes the publicly available data in 'FinBIF' easily accessible to programmers. Biodiversity information is available on taxonomy and taxon occurrence. Occurrence data can be filtered by taxon, time, location and other variables. The data accessed are conveniently preformatted for subsequent analyses.
}
\section{Package options}{

\describe{
\item{\code{finbif_api_url}}{Character. The base url of the API to query. Default:
\code{"https://api.laji.fi"}}
\item{\code{finbif_api_version}}{Character. The API version to use. Default:
\code{"v0"}}
\item{\code{finbif_allow_query}}{Logical. Should remote API queries by allowed.
Default: \code{TRUE}}
\item{\code{finbif_use_cache}}{Logical. Should API queries by cached. Default:
\code{TRUE}}
\item{\code{finbif_cache_path}}{Character. The path to the directory where to
store cached API queries. If unset (the default) in memory caching is
used.}
\item{\code{finbif_tz}}{Character. The timezone used by \code{finbif} functions that
compute dates and times. Default: \code{Sys.timezone()}}
\item{\code{finbif_locale}}{Character. One of the supported two-letter ISO 639-1
language codes. Current supported languages are English, Finnish, Swedish,
Russian, and Sámi (Northern). By default, the system settings are used to
set this option if they are set to one of the supported languages,
otherwise English is used.}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/luomus/finbif}
  \item \url{https://luomus.github.io/finbif/}
  \item Report bugs at \url{https://github.com/luomus/finbif/issues}
}

}
\author{
\strong{Maintainer}: William K. Morris \email{willi@mmorris.email} (\href{https://orcid.org/0000-0002-8686-4154}{ORCID})

Other contributors:
\itemize{
  \item Finnish Museum of Natural History - Luomus [copyright holder]
}

}
