% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.solve_iterative}
\alias{.solve_iterative}
\title{Iterative solver for final size.}
\usage{
.solve_iterative(
  contact_matrix,
  demography_vector,
  susceptibility,
  iterations = 10000L,
  tolerance = 1e-06,
  step_rate = 1.9,
  adapt_step = TRUE
)
}
\arguments{
\item{contact_matrix}{Social contact matrix. Entry \eqn{mm_{ij}} gives
average number of contacts in group \eqn{i} reported by participants in
group \eqn{j}.}

\item{demography_vector}{Demography vector. Entry \eqn{pp_{i}} gives
proportion of total population in group \eqn{i}
(model will normalise if needed).}

\item{susceptibility}{A matrix giving the susceptibility of individuals in
demographic group \eqn{i} and risk group \eqn{j}.}

\item{iterations}{Number of solver iterations. Defaults to 10,000.}

\item{tolerance}{Solver error tolerance. Solving for final size ends when
the error drops below this tolerance. Defaults to set \code{1e-6}.
Larger tolerance values are likely to lead to inaccurate final size
estimates.}

\item{step_rate}{The solver step rate. Defaults to 1.9 as a value found to
work well.}

\item{adapt_step}{Boolean, whether the solver step rate should be changed
based on the solver error. Defaults to TRUE.}
}
\value{
A vector of final sizes, of the size (N demography groups *
N risk groups).
}
\description{
Iterative solver for final size.
}
\keyword{internal}
