% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxphmulti.R
\name{coxphmulti}
\alias{coxphmulti}
\title{Cox proprotional hazards multivariable models: \code{finalfit} model wrapper}
\usage{
coxphmulti(.data, dependent, explanatory)
}
\arguments{
\item{.data}{Dataframe.}

\item{dependent}{Character vector of length 1:  name of survival object in
form \code{Surv(time, status)}.}

\item{explanatory}{Character vector of any length: name(s) of explanatory
variables.}
}
\value{
A list of univariable \code{\link[survival]{coxph}} fitted model
  outputs. Output is of class \code{coxphlist}.
}
\description{
Using \code{finalfit} conventions, produces multiple multivariable Cox
Proportional Hazard regression models for a set of explanatory variables
against a survival object.
}
\details{
Uses \code{\link[survival]{coxph}} with \code{finalfit} modelling
conventions. Output can be passed to \code{\link{fit2df}}.
}
\examples{
# Cox Proportional Hazards multivariable analysis.
library(finalfit)
library(dplyr)

explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "Surv(time, status)"
colon_s \%>\%
	coxphmulti(dependent, explanatory) \%>\%
	fit2df()
}
\seealso{
\code{\link{fit2df}, \link{finalfit_merge}}

Other \code{finalfit} model wrappers: \code{\link{coxphuni}},
  \code{\link{glmmixed}}, \code{\link{glmmulti_boot}},
  \code{\link{glmmulti}}, \code{\link{glmuni}},
  \code{\link{lmmixed}}, \code{\link{lmmulti}},
  \code{\link{lmuni}}
}
\concept{\code{finalfit} model wrappers}
