% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_glimpse.R
\name{ff_glimpse}
\alias{ff_glimpse}
\alias{finalfit_glimpse}
\title{Descriptive statistics for dataframe}
\usage{
ff_glimpse(.data, dependent = NULL, explanatory = NULL, digits = 1)

finalfit_glimpse(.data, dependent = NULL, explanatory = NULL,
  digits = 1)
}
\arguments{
\item{.data}{Dataframe.}

\item{dependent}{Optional character vector: name(s) of depdendent
variable(s).}

\item{explanatory}{Optional character vector: name(s) of explanatory
variable(s).}

\item{digits}{Significant digits for continuous variable summaries}
}
\value{
Dataframe on summary data.
}
\description{
Everyone has a funcion like this, str, glimpse, glance etc. This one is
specifically designed for use with \code{finalfit} language. It is different
in dividing variables by numeric vs factor, the former using
\code{link[psych]{describe}}.
}
\examples{
library(finalfit)
dependent = 'mort_5yr'
explanatory = c("age.factor", "extent.factor", "perfor.factor")
colon_s \%>\%
  finalfit_glimpse(dependent, explanatory)
}
