% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{cft_rcvrs}
\alias{cft_rcvrs}
\title{Example receiver data from CalFishTrack}
\format{
\subsection{\code{cft_rcvrs}}{

A dataframe of 1,130 rows and 12 columns:
\describe{
\item{dep_id}{a unique number that identifies a single deployment}
\item{receiver_serial_number}{the serial number of the acoustic receiver
that recorded the detection. If this value is 1, then the record is not a
receiver detection but is the release date-time and location. Every
tagged fish has at least one record in the table}
\item{receiver_general_location}{A name for the geographic location of one
or more receivers.}
\item{receiver_region}{A name for a larger geographic region that defines a
subarea of the Central Valley watershed. Some regions are Upper Sac R,
Lower Sac R, Feather R, East Delta, West Delta, SF Bay.}
\item{receiver_location}{The name for the location of a single receiver}
\item{latitude}{Latitude for the exact location of a single receiver.
If unknown = cell is blank}
\item{longitude}{Longitude for the exact location of a single receiver. If
unknown = cell is blank}
\item{receiver_river_km}{River kilometer for the location of a single
receiver. Must be unique for each GPSname. The Golden Gate Bridge is rkm 0.
Values increase the further upstream}
\item{receiver_make}{Describes the manufacturer and type of JSATS receiver.}
\item{receiver_depth}{the estimated depth of the receiver hydrophone. If
unknown = blank}
\item{receiver_start}{	The date and time in Pacific Standard Time when the
receiver was deployed (put at the site in the water). Format: date time
M/DD/YYYY HH:MM}
\item{receiver_end}{The date and time in Pacific Standard Time when the
receiver was recovered (removed from the water). Format: date time
M/DD/YYYY HH:MM}
\item{receiver_last_valid}{	Taken from the detection data file for this
deployment, the date and time in Pacific Standard Time of the last valid
detection or sensor data entry. This time cannot be greater than the
EndTime, but can be less that the EndTime if receiver quit recording data
or was pulled out of the water. Format: date time M/DD/YYYY HH:MM}
\item{receiver_data_coverage}{	describes how extensive the data is for this
receiver deployment. If the receiver failed to work or was lost and not
recovered = none. If it worked for part of the deployment = partial. If
the receiver worked the entire deployment = full. Can be blank.}
\item{receiver_coverage_problem}{If the receiver did not work until EndTime
then an entry here describes the reason why the receiver may have failed.}
\item{receiver_agency}{The agency (abbreviated) managing the receiver
deployment.}
\item{receiver_beacon_id_hex}{The hex code of the beacon tag associated
with this receiver deployment}
\item{	receiver_beacon_id_dec}{The decimal code of the beacon tag
associated with this receiver deployment}
\item{receiver_beacon_pri}{The pulse rate interval of the beacon tag in
secs, usually 60 or 30 secs}
}
}
}
\usage{
cft_rcvrs
}
\description{
A dataframe of acoustic receiver metadata downloaded from ERDDAP representing
receivers deployed from 2021-2022.
}
\keyword{datasets}
