% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_fish.R
\name{format_fish}
\alias{format_fish}
\title{Format Fish Data for add_fish()}
\usage{
format_fish(
  data,
  var_Id,
  var_release,
  var_tag_life,
  var_ping_rate,
  local_time_zone,
  time_format
)
}
\arguments{
\item{data}{a dataframe of fish and tag data}

\item{var_Id}{the column name, in quotes, which identifies the individual
transmitter/tag/organism identifier.}

\item{var_release}{the column name, in quotes, which identifies the release
date and time in POSIX format and appropriate timezone}

\item{var_tag_life}{the column name, in quotes, which identified the expected
tag life in days}

\item{var_ping_rate}{the column name, in quotes which identifies the expected
ping rate of the tag/transmitter}

\item{local_time_zone}{the local timezone used for analyses. Uses tz database
names (e.g. "America/Los_Angeles" for Pacific Time)}

\item{time_format}{a string value indicating the datetime format of all time
fields}
}
\value{
A dataframe which contains fields renamed to match those required by
add_org() function
}
\description{
This function takes a dataframe of fish and tag data and renames the
columns to those expected by the add_fish() function
}
\examples{
# Rename columns to work with functions
format_fish(data = fish,
            var_Id = "TagCode",
            var_release = "Release_Date",
            var_tag_life = "TagLife",
            var_ping_rate = "PRI",
            local_time_zone = "America/Los_Angeles",
            time_format = "\%Y-\%m-\%d \%H:\%M:\%S")
}
