#' Add Receiver Data to a Completely Filtered Detection File
#'
#' This function takes any acoustic receiver detection dataframe which contains
#' receiver serial numbers in a `ReceiverSN` field, such as that produced by
#' `second_filter_*()`, and joins it with receiver metadata generated by
#' the `get_rcvr_data()` or `format_receiver()` functions.
#'
#'
#' @param final_file a dataframe of detections retrieved from second_filter
#' @param rcvr_data a dataframe of receiver metadata retrieved from get_rcvr_data
#' @returns A dataframe to which receiver metadata has been added.
#' @export
#' @examples
#' # Join receiver metadata to detection data
#' join_rcvr_data(fish_detects, cft_rcvrs)
join_rcvr_data <- function(final_file, rcvr_data){
  out <- dplyr::left_join(final_file,rcvr_data,by = "ReceiverSN")
  out <- out[out$DateTime_Local > out$receiver_start &
               out$DateTime_Local < out$receiver_end,]
  out
}
