% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str-locate.R
\name{str_nth_instance_indices}
\alias{str_nth_instance_indices}
\alias{str_first_instance_indices}
\alias{str_last_instance_indices}
\title{Get the indices of the \eqn{n}th instance of a pattern.}
\usage{
str_nth_instance_indices(string, pattern, n)

str_first_instance_indices(string, pattern)

str_last_instance_indices(string, pattern)
}
\arguments{
\item{string}{A character vector. These functions are vectorized over this
argument.}

\item{pattern}{A character vector. Pattern(s) specified like the pattern(s)
in the stringr package (e.g. look at \code{\link[stringr:str_locate]{stringr::str_locate()}}). If
this has length >1 its length must be the same as that of \code{string}.}

\item{n}{Then \eqn{n} for the \eqn{n}th instance of the pattern.}
}
\value{
A two-column matrix. The \eqn{i}th row of this matrix gives the start
and end indices of the \eqn{n}th instance of \code{pattern} in the \eqn{i}th
element of \code{string}.
}
\description{
The \eqn{n}th instance of an pattern will cover a series of character
indices. These functions tell you which indices those are.
}
\details{
\itemize{ \item \code{str_first_instance_indices(...)} is just
\code{str_nth_instance_indices(..., n = 1)}. \item
\code{str_last_instance_indices(...)} is just \code{str_nth_instance_indices(..., n = -1)}. }
}
\examples{
str_nth_instance_indices(c("abcdabcxyz", "abcabc"), "abc", 2)

}
