% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{str_with_patterns}
\alias{str_with_patterns}
\title{Which strings match the patterns?}
\usage{
str_with_patterns(strings, patterns, ignore_case = FALSE, any = FALSE)
}
\arguments{
\item{strings}{A character vector.}

\item{patterns}{Regular expressions.}

\item{ignore_case}{Do we want to ignore case when matching patterns?}

\item{any}{Set this to \code{TRUE} if you want to see which strings match
\emph{any} of the patterns and not \emph{all} (all is the default).}
}
\value{
A character vector of strings matching the patterns.
}
\description{
Given a character vector of strings and one of patterns (in regular
expression), which of the strings match all (or any) of the patterns.
}
\details{
For huge character vectors, this can be quite slow and you're better off
implementing your own solution with \code{\link[stringr:str_detect]{stringr::str_detect()}}.
}
\examples{
str_with_patterns(c("abc", "bcd", "cde"), c("b", "c"))
str_with_patterns(c("abc", "bcd", "cde"), c("b", "c"), any = TRUE)
str_with_patterns(toupper(c("abc", "bcd", "cde")), c("b", "c"), any = TRUE)
str_with_patterns(toupper(c("abc", "bcd", "cde")), c("b", "c"), any = TRUE,
                  ignore_case = TRUE)
}
