% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.to.color.R
\name{gradient.legend}
\alias{gradient}
\alias{gradient.legend}
\title{Create a gradiented legend}
\usage{
gradient.legend(y = NULL, yrange = NULL, cols = c("red", "blue"),
  location = c(0.075, 0.3, 0.575, 0.975), n = 100, ...)
}
\arguments{
\item{y}{the variable used to create the gradient, typically in \code{\link{number.to.colors}}}

\item{yrange}{The range of y values. If y is supplied, it will pulls these from the actual y values.}

\item{cols}{The color gradients to be used that are passed to \code{\link{colorRampPalette}}.}

\item{location}{The location of the subplot, expressed in fractions of the entire plot (left x, right x,
bottom y, top y).}

\item{n}{the number of values used for the gradient. Higher numbers make a higher resolution}

\item{...}{other arguments passed to image}
}
\description{
Create a gradiented legend
}
\examples{
y = rnorm(100); x = .6*y + rnorm(100,0,sqrt(1-.6^2))
randnum = runif(100)
plot(x,y, col=number.to.colors(randnum), pch=16)
gradient.legend(randnum, xlab="", ylab="")
}
\author{
Dustin Fife
}
\seealso{
\code{\link{number.to.colors}} \code{\link{colorRampPalette}}
}

