% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colored.table.R
\name{colored.table}
\alias{col.table}
\alias{color.table}
\alias{colored.table}
\title{Create a color-coded table in latex}
\usage{
colored.table(data, file, dep.var, row.factors, col.factors, breaks = 4,
  round = 2, rng = NULL, FUN = mean, row.prefix = NULL,
  col.prefix = NULL, custom.breaks = NULL, return.table = F, ...)
}
\arguments{
\item{data}{the dataset in "long" format, where the conditions are on columns.}

\item{file}{the location where the file should be exported.}

\item{dep.var}{A string naming the dependent variable}

\item{row.factors}{A vector of one or two elements, each of which is a string indicating the name of the row factor(s)}

\item{col.factors}{A vector of one or two elements, each of which is a string indicating the name of the col factor(s)}

\item{breaks}{The number of breaks in color. Defaults to 4.}

\item{round}{How many digits should the matrix be rounded to? Defaults to 2.}

\item{rng}{The range of values used for coloring the plot.}

\item{FUN}{The function used to summarize the table (defaults to mean)}

\item{row.prefix}{Any values that precede the rows (e.g., "r^2 = ").}

\item{col.prefix}{Any values that precede the columns.}

\item{custom.breaks}{The points at which the colored table changes colors. If left to NULL, the function will automatically choose them.}

\item{return.table}{Should the function return the table as output?}

\item{...}{Other arguments passed to Hmisc}
}
\description{
Create a color-coded table in latex
}
\examples{
## do this later
}
\author{
Dustin Fife
}
\seealso{
\code{Hmisc::latex}
}

