\name{as.surface}
\alias{as.surface}
\title{
  Creates an "surface" object from grid values. 
}
\description{
Reformats the vector from evaluating  a function on a grid of points into 
a list for use with surface plotting function. The list has the
usual components x,y and z and is suitable for use with persp, contour,
image and image.plot.
 
}
\usage{
as.surface(obj, z, order.variables="xy")
}
\arguments{
\item{obj}{
A description of the grid used to evaluate the function. This can 
either be in the form of a grid.list 
( see help file for grid.list) or the matrix of grid of points produced 
by make.surface.grid. In the later case obj is a matrix with 
the grid.list as an attribute. 
}
\item{z}{
The value of the function evaluated at the gridded points. 
}
\item{order.variables}{
Either "xy" or "yx" specifies how the x and y variables used to 
evaluate the function are matched with the x and y grids in the surface 
object. 
}
}
\value{
A list of class surface. This object is a modest generalization of the 
list input format (x,y,z,) for the S functions contour, image or persp.  

\item{x}{
The grid values in the  X-axis
}
\item{y}{
The grid values in the  Y-axis
}
\item{z}{
A matrix of dimensions nrow= length of x and ncol= length of y with
entries being the  grid point value reformatted from z. 
}
}
\details{
This function was written to simply to go back and forth between a
matrix of gridded values and the stacked vector obtained by stacking
columns. The main application is evaluating a function at each grid point
and then reforming the results for plotting. (See example below.)

If zimage is matrix of values then the input vector is c( zimage).
To go from the stacked vector to the matrix one needs the the nrow ncol
and explains why grid information must also be specified.
 
Note that the z input argument must be in the order 
values in order of stacking columns of the image. This is also the
order of the grid points generated by make.surface.grid.

To convert irregular 2-d data to a surface object where there are missing
cells see the function as.image. 
}
\seealso{
 grid.list, make.surface.grid, surface, contour,
image.plot, as.image 
}
\examples{
 

# Make a perspective of the surface Z= X**2 -Y**2 
# Do this by evaluating quadratic function on a 25 X 25 grid
  
grid.l<-list( abcissa= seq( -2,2,,15), ordinate= seq( -2,2,,20)) 
xg<-make.surface.grid( grid.l)
# xg is a 300X2 matrix that has all pairs of X and Y grid values 
z<- xg[,1]**2 - xg[,2]**2  
# now fold z in the matrix format needed for persp 
out.p<-as.surface( xg, z) 
persp( out.p) 
# also try  plot( out.p) to see the default plot for a surface object 
}
\keyword{manip}
% docclass is function
% Converted by Sd2Rd version 1.21.
