% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_utils.R
\name{all_inds.default}
\alias{all_inds.default}
\alias{all_inds}
\alias{all_inds.lm}
\alias{all_inds.glm}
\alias{all_inds.coxph}
\title{Form indicator matrix describing all submodels of a general linear wide model}
\usage{
\method{all_inds}{default}(wide, inds0 = NULL, auxpars = NULL, ...)

all_inds(wide, inds0, ...)

\method{all_inds}{lm}(wide, inds0, ...)

\method{all_inds}{glm}(wide, inds0, ...)

\method{all_inds}{coxph}(wide, inds0, ...)
}
\arguments{
\item{wide}{A fitted model of standard R format, such that \code{terms(wide)} returns information about the terms of the model formula.  Models outside standard R packages may not support this.}

\item{inds0}{Narrow model indicators, in format described in \code{\link{fic}}.}

\item{auxpars}{Names of parameters in the wide model other than the covariate effects being selected from.  By default, for linear and generalised linear models this is \code{c("(Intercept)")}, and for Cox regression this is omitted.}

\item{...}{Other arguments. Currently unused.}
}
\value{
A matrix in the format required by the \code{inds} argument of \code{fic()}, representing all possible submodels of the wide model.

The number of rows is the number of models, and the number of columns is the number of parameters in the wide model.   The \eqn{r,s} entry of the matrix is a 1 if the \eqn{r}th submodel includes parameter \eqn{s}, and 0 otherwise.

If a factor is included (excluded) from the submodel, then all corresponding parameters are included (excluded).

See the package vignettes for examples.
}
\description{
Form indicator matrix describing all possible submodels of a general linear wide model, where the submodels are defined by selected covariates.
}
\examples{
bwt.glm <- glm(low ~ lwtkg + age + smoke, data=birthwt, family="binomial")
all_inds(bwt.glm, inds0=c(1,0,0,0))

# note no intercept term in Cox models, so inds0 has two elements here
library(survival)
wide <- coxph(Surv(years, death==1) ~ sex + thick_centred, data=melanoma)
all_inds(wide, inds0=c(0,0))

}
