% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhir_tree.R
\name{fhir_tree}
\alias{fhir_tree}
\title{Represent a wide cast table as a tree}
\usage{
fhir_tree(
  table,
  brackets,
  resource = "Resource",
  keep_attr = FALSE,
  keep_ids = FALSE,
  skip_one = FALSE,
  format = "plain",
  prompt = ": "
)
}
\arguments{
\item{table}{A data.frame or data.table as produced by \code{\link[=fhir_crack]{fhir_crack()}} with \code{format="wide"} or \code{\link[=fhir_cast]{fhir_cast()}}}

\item{brackets}{A character vector of length two. The brackets used in the table.}

\item{resource}{A character vector of length one or \linkS4class{fhir_resource_type} object indicating which resource type the table is build from.}

\item{keep_attr}{A logical vector of length one indicating whether attributes should be displayed or not.
Only used for formats \code{"plain"} and \code{"fancy"}.}

\item{keep_ids}{A logical vector of length one indicating whether indices should be displayed or not.
Only used for formats \code{"plain"} and \code{"fancy"}.}

\item{skip_one}{A logical vector of length one indicating whether first index 1 should be displayed or not.
Only used for formats \code{"plain"} and \code{"fancy"}.}

\item{format}{The format of the tree. One of \code{"plain"}, \code{"fancy"} or \code{"xml"}.}

\item{prompt}{A character vector of length one use as prompt
Only used for formats \code{"plain"} and \code{"fancy"}.}
}
\value{
A string that can be used with \code{cat()} or can be written to a text file.
}
\description{
This function takes a wide table as created by \code{\link[=fhir_crack]{fhir_crack()}} with \code{format="wide"}and creates the tree structure implicit in the
column names of the tables. It is useful to get an overview over the implied structure when planning to create
FHIR bundles from this table using \code{\link[=fhir_build_bundle]{fhir_build_bundle()}}.
}
\examples{
#' #unserialize example
bundles <- fhir_unserialize(bundles = example_bundles1)

#crack fhir resources
table_desc <- fhir_table_description(
    resource = "Patient",
    brackets = c("[", "]"),
    sep      = " ",
    format   = "wide"
)

df <- fhir_crack(bundles = bundles, design = table_desc)


###show tree

#plain format
cat(fhir_tree(
       table = df,
       brackets = c("[", "]"),
       resource = "Patient"
    )
 )

#fancy format with indices
cat(fhir_tree(
       table = df,
       brackets = c("[", "]"),
       resource = "Patient",
       format = "fancy",
       keep_ids = TRUE
     )
)

#xml format
cat(fhir_tree(
       table = df,
       brackets = c("[", "]"),
       resource = "Patient",
       format = "xml"
     )
 )
}
\seealso{
\code{\link[=fhir_cast]{fhir_cast()}}, \code{\link[=fhir_build_bundle]{fhir_build_bundle()}}
}
